
#include "SDCard.h"
#include "Infrared.h"
#include "p33Fxxxx.h"

#ifndef BOOTLOADER
#define CHAIN_INTERRUPT

volatile unsigned char memoryCardSystemUp;

#ifdef CHAIN_INTERRUPT
static void sdcard_CNInterrupt(void) {
#else
void __attribute__((__interrupt__,no_auto_psv)) _CNInterrupt(void) {
#endif
	memoryCardSystemUp = sdcard_get_presence();
#ifndef CHAIN_INTERRUPT
	IFS1bits.CNIF = 0;
#endif
}
#endif

void sdcard_init() {
	// power control is on RB0, active-low
	TRISBbits.TRISB0 = 0;
	LATBbits.LATB0 = 1;

	// card detect is on RB11/CN15, active-low
	TRISBbits.TRISB11 = 1;
	CNPU1bits.CN15PUE = 1;
	// enable change notification
#ifdef CHAIN_INTERRUPT
	ir_cn_interrupt_chain = &sdcard_CNInterrupt;
#endif
	CNEN1bits.CN15IE = 1;
#ifndef BOOTLOADER
#ifndef CHAIN_INTERRUPT
	IFS1bits.CNIF = 0;
	IEC1bits.CNIE = 1;
#endif
	memoryCardSystemUp = sdcard_get_presence();
#endif

	AD1PCFGLbits.PCFG9 = 1;
	AD1PCFGLbits.PCFG10 = 1;
	AD1PCFGLbits.PCFG11 = 1;
	AD1PCFGLbits.PCFG12 = 1;
	RPOR7bits.RP14R = 10;   // SPI2 data output
	RPOR6bits.RP13R = 11;   // SPI2 clock output
	RPINR22bits.SDI2R = 12; // SPI2 data input
}

void sdcard_set_power(unsigned char bPowered) {
	AD1PCFGLbits.PCFG9 = bPowered;
	AD1PCFGLbits.PCFG10 = bPowered;
	AD1PCFGLbits.PCFG11 = bPowered;
	AD1PCFGLbits.PCFG12 = bPowered;

	LATBbits.LATB0 = !bPowered;
}

unsigned char sdcard_get_presence() {
	return PORTBbits.RB11 == 0;
}
